//
//  PITItemStore.h
//  PIT
//
//  Created by VA DEVELOPER on 11/24/12.
//  Copyright (c) 2012. All rights reserved.
//

#import <Foundation/Foundation.h>


@class PITItem;

@interface PITItemStore : NSObject {
    NSMutableArray *allItems;
}

+ (PITItemStore *) sharedStore;

- (NSArray *) allItems;
- (PITItem *) createItem;
- (void) removeItem: (PITItem *)p;
- (void) moveItemAtIndex:(int)from toIndex:(int)to;

- (NSString *) itemArchivePath;
- (BOOL) saveChanges;
- (BOOL) backupChanges;
- (BOOL) protectFile: (NSString *) path;

@end
